package w83b.w83bOperacionesPaso.w83bMantenimientos.w83bMotivosBajaDelegado;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bMotivosBajaDelegadoBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaMotivosBajaDelegadoExcelAction extends Q70ActionPasoOP{


	/**
	 * processOP.
	 *
	 * @param contexto a
	 * @param errores a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @throws Exception e
	 */	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}
	
	/**
	 * processForward.
	 *
	 * @param contexto a
	 * @param errors a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @return ActionForward
	 * @throws Exception e
	 */	
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoMotivosBajaDelegado.xls";
		InputStream inputStream = W83bTablaMotivosBajaDelegadoExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaMotivos = (ArrayList)contexto.get("w83bListaMotivos");
        W83bMotivosBajaDelegadoBean motivoBajaDelegadoBean = (W83bMotivosBajaDelegadoBean)contexto.get("w83bMotivosTempBean");       
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);       

        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);       
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);       

        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));       
        HashMap mapaBajaDelegado=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);       
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1       
        HSSFCell cell = row.createCell((short)3);       
        row = sheet.getRow((short)4);       
        cell = row.getCell((short)2);       
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaBajaDelegado.get("tituloDepEs");       
        StringBuffer tituloImagenEu =  (StringBuffer)mapaBajaDelegado.get("tituloDepEu");       
        cell.setCellValue(tituloImagenEu.toString());       
        
        cell = row.getCell((short)5);       
        cell.setCellValue(tituloImagenEs.toString());       
        
        tituloImagenEs = (StringBuffer)mapaBajaDelegado.get("tituloDelelegacionEs");       
        tituloImagenEu = (StringBuffer)mapaBajaDelegado.get("tituloDelelegacionEu");       

        row = sheet.getRow((short)6);       
        cell = row.getCell((short)2);       
        cell.setCellValue(tituloImagenEu.toString());       
        
        cell = row.getCell((short)5);       
        cell.setCellValue(tituloImagenEs.toString());       
        
        row = sheet.getRow((short)9);        
        cell = row.getCell((short)0);       
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.motbajadel.nombreListado").toUpperCase());       
        
        //MAPEO FORMULARIO
        row = sheet.getRow(Short.parseShort("12")); 
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.motbajadel.codMotivo"));
        cell = row.createCell(Short.parseShort("2"));
        if(!StringUtils.isEmpty(motivoBajaDelegadoBean.getCodMotivoBajaDelegado())){
        	if(StringUtils.isNotEmpty(motivoBajaDelegadoBean.getCodMotivoBajaDelegado())){
        		cell.setCellValue(W83bUtilidades.numero(motivoBajaDelegadoBean.getCodMotivoBajaDelegado().toUpperCase()));
        	}
        	cell.setCellStyle(estiloCabeceraIzquierda(12,excel));
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
         
        cell = row.getCell(Short.parseShort("5"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.herramientas.baja"));
        cell = row.createCell(Short.parseShort("7"));

        if(StringUtils.isEmpty(motivoBajaDelegadoBean.getBaja())||W83bClsConstantes.CONSTANTE_NO.equals(motivoBajaDelegadoBean.getBaja())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase());
        }else{
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase());
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        
        row = sheet.getRow(Short.parseShort("13"));
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.motbajadel.descMotivoCast"));
        cell = row.createCell(Short.parseShort("2")); 
        if(StringUtils.isNotEmpty(motivoBajaDelegadoBean.getDescMotivoBajaDelegadoCast())){
	        sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("2"),W83bClsConstantes.TRECE,Short.parseShort("4")));//NOPMD
	        if(StringUtils.isNotEmpty(motivoBajaDelegadoBean.getDescMotivoBajaDelegadoCast())){
	        	cell.setCellValue(motivoBajaDelegadoBean.getDescMotivoBajaDelegadoCast().toUpperCase());
	        }
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("5"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.motbajadel.descMotivoEusk"));
        cell = row.createCell(Short.parseShort("7"));
        if(StringUtils.isNotEmpty(motivoBajaDelegadoBean.getDescMotivoBajaDelegadoEusk())){
	        sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("7"),W83bClsConstantes.TRECE,Short.parseShort("9")));//NOPMD
	        if(StringUtils.isNotEmpty(motivoBajaDelegadoBean.getDescMotivoBajaDelegadoEusk())){
	        	cell.setCellValue(motivoBajaDelegadoBean.getDescMotivoBajaDelegadoEusk().toUpperCase());
	        }
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
		}else{
	        cell.setCellValue("");
	    }
        
        if((motivoBajaDelegadoBean.getDescMotivoBajaDelegadoCast()).length()>=(motivoBajaDelegadoBean.getDescMotivoBajaDelegadoEusk()).length()){
	        if(51<motivoBajaDelegadoBean.getDescMotivoBajaDelegadoCast().length()){
	    		row.setHeightInPoints((short)(18*((motivoBajaDelegadoBean.getDescMotivoBajaDelegadoCast()).length()/51)+1));
	    	}
        }else{
        	if(43<motivoBajaDelegadoBean.getDescMotivoBajaDelegadoEusk().length()){
         		row.setHeightInPoints((short)(18*((motivoBajaDelegadoBean.getDescMotivoBajaDelegadoEusk()).length()/43)+1));
         	}
        }
        
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        row = sheet.getRow(Short.parseShort("16"));
        cell = row.getCell(Short.parseShort("0"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.motbajadel.codMotivo"));
        
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.motbajadel.descMotivoCast"));
        
        cell = row.getCell(Short.parseShort("5"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.motbajadel.descMotivoEusk"));
        for(int i=0;i<listaMotivos.size();i++){
        	row = sheet.createRow((short)W83bClsConstantes.DIECISIETE+i); // Creacin de la fila 1//NOPMD
        	
        	cell = row.createCell(Short.parseShort("0")); 
        	if(!StringUtils.isEmpty(((W83bMotivosBajaDelegadoBean)listaMotivos.get(i)).getCodMotivoBajaDelegado())){
	        	cell.setCellValue(W83bUtilidades.numero(((W83bMotivosBajaDelegadoBean)listaMotivos.get(i)).getCodMotivoBajaDelegado()));
	        }else{
	        	cell.setCellValue("");
	        }
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell(Short.parseShort("1"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+i,Short.parseShort("1"),W83bClsConstantes.DIECISIETE+i,Short.parseShort("4")));//NOPMD
        	if(!StringUtils.isEmpty(((W83bMotivosBajaDelegadoBean)listaMotivos.get(i)).getDescMotivoBajaDelegadoCast())){
        		cell.setCellValue(((W83bMotivosBajaDelegadoBean)listaMotivos.get(i)).getDescMotivoBajaDelegadoCast());
	        }else{
	        	cell.setCellValue("");
	        }
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("2")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("3")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("4")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	cell = row.createCell(Short.parseShort("5"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+i,Short.parseShort("5"),W83bClsConstantes.DIECISIETE+i,Short.parseShort("9")));//NOPMD
        	if(!StringUtils.isEmpty(((W83bMotivosBajaDelegadoBean)listaMotivos.get(i)).getDescMotivoBajaDelegadoEusk())){
        		cell.setCellValue(((W83bMotivosBajaDelegadoBean)listaMotivos.get(i)).getDescMotivoBajaDelegadoEusk());
	        }else{
	        	cell.setCellValue("");
	        }
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("6")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("7")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("8")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("9")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	if(StringUtils.isNotEmpty(((W83bMotivosBajaDelegadoBean)listaMotivos.get(i)).getDescMotivoBajaDelegadoCast()) 
        			&& StringUtils.isNotEmpty(((W83bMotivosBajaDelegadoBean)listaMotivos.get(i)).getDescMotivoBajaDelegadoEusk())){
	        	if((((W83bMotivosBajaDelegadoBean)listaMotivos.get(i)).getDescMotivoBajaDelegadoCast()).length()>=(((W83bMotivosBajaDelegadoBean)listaMotivos.get(i)).getDescMotivoBajaDelegadoEusk()).length()){
		        	if(85<(((W83bMotivosBajaDelegadoBean)listaMotivos.get(i)).getDescMotivoBajaDelegadoCast()).length()){
		        		row.setHeightInPoints((short)(22*((((W83bMotivosBajaDelegadoBean)listaMotivos.get(i)).getDescMotivoBajaDelegadoCast()).length()/85)+1));
		        	}
		        }else{
		        	if(83<(((W83bMotivosBajaDelegadoBean)listaMotivos.get(i)).getDescMotivoBajaDelegadoEusk()).length()){
		        		row.setHeightInPoints((short)(22*((((W83bMotivosBajaDelegadoBean)listaMotivos.get(i)).getDescMotivoBajaDelegadoEusk()).length()/83)+1));
		        	}
		        }
        	}
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoMotivosBajaDelegados.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	/**
	 * Estilo fila.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	/**
	 * Estilo cabecera izquierda.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloCabeceraIzquierda(int nFila, W83bUtilidadesExcel excel){
		return excel.styleCabeceraIzquierda;
	}
		
	/**
	 * Estilo fila numero centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;//NOPMD
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}
}
